<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\AlertCenter;

class AccountSuspensionDetails extends \Google\Model
{
  /**
   * Abuse reason is unspecified.
   */
  public const ABUSE_REASON_ACCOUNT_SUSPENSION_ABUSE_REASON_UNSPECIFIED = 'ACCOUNT_SUSPENSION_ABUSE_REASON_UNSPECIFIED';
  /**
   * This account is being suspended for a Terms of Service violation.
   */
  public const ABUSE_REASON_TOS_VIOLATION = 'TOS_VIOLATION';
  /**
   * This account is being suspended for spam.
   */
  public const ABUSE_REASON_SPAM = 'SPAM';
  /**
   * This account is being suspended for phishing.
   */
  public const ABUSE_REASON_PHISHING = 'PHISHING';
  /**
   * This account is being suspended for artificially boosting traffic to a
   * website.
   */
  public const ABUSE_REASON_TRAFFIC_PUMPING = 'TRAFFIC_PUMPING';
  /**
   * This account is being suspended for fraud.
   */
  public const ABUSE_REASON_FRAUD = 'FRAUD';
  /**
   * This account is being suspended for number harvesting.
   */
  public const ABUSE_REASON_NUMBER_HARVESTING = 'NUMBER_HARVESTING';
  /**
   * This account is being suspended for payments fraud.
   */
  public const ABUSE_REASON_PAYMENTS_FRAUD = 'PAYMENTS_FRAUD';
  /**
   * This account is being suspended for unwanted content.
   */
  public const ABUSE_REASON_UNWANTED_CONTENT = 'UNWANTED_CONTENT';
  /**
   * This account is being suspended for being an unqualified educational
   * institution.
   */
  public const ABUSE_REASON_UNQUALIFIED_EDU = 'UNQUALIFIED_EDU';
  /**
   * The reason why this account is receiving an account suspension warning.
   *
   * @var string
   */
  public $abuseReason;
  /**
   * The name of the product being abused. This is restricted to only the
   * following values: "Gmail" "Google Workspace" "Payments" "Voice" "YouTube"
   * "Other"
   *
   * @var string
   */
  public $productName;

  /**
   * The reason why this account is receiving an account suspension warning.
   *
   * Accepted values: ACCOUNT_SUSPENSION_ABUSE_REASON_UNSPECIFIED,
   * TOS_VIOLATION, SPAM, PHISHING, TRAFFIC_PUMPING, FRAUD, NUMBER_HARVESTING,
   * PAYMENTS_FRAUD, UNWANTED_CONTENT, UNQUALIFIED_EDU
   *
   * @param self::ABUSE_REASON_* $abuseReason
   */
  public function setAbuseReason($abuseReason)
  {
    $this->abuseReason = $abuseReason;
  }
  /**
   * @return self::ABUSE_REASON_*
   */
  public function getAbuseReason()
  {
    return $this->abuseReason;
  }
  /**
   * The name of the product being abused. This is restricted to only the
   * following values: "Gmail" "Google Workspace" "Payments" "Voice" "YouTube"
   * "Other"
   *
   * @param string $productName
   */
  public function setProductName($productName)
  {
    $this->productName = $productName;
  }
  /**
   * @return string
   */
  public function getProductName()
  {
    return $this->productName;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AccountSuspensionDetails::class, 'Google_Service_AlertCenter_AccountSuspensionDetails');
