<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudAsset;

class ZypperPatch extends \Google\Model
{
  /**
   * The category of the patch.
   *
   * @var string
   */
  public $category;
  /**
   * The name of the patch.
   *
   * @var string
   */
  public $patchName;
  /**
   * The severity specified for this patch
   *
   * @var string
   */
  public $severity;
  /**
   * Any summary information provided about this patch.
   *
   * @var string
   */
  public $summary;

  /**
   * The category of the patch.
   *
   * @param string $category
   */
  public function setCategory($category)
  {
    $this->category = $category;
  }
  /**
   * @return string
   */
  public function getCategory()
  {
    return $this->category;
  }
  /**
   * The name of the patch.
   *
   * @param string $patchName
   */
  public function setPatchName($patchName)
  {
    $this->patchName = $patchName;
  }
  /**
   * @return string
   */
  public function getPatchName()
  {
    return $this->patchName;
  }
  /**
   * The severity specified for this patch
   *
   * @param string $severity
   */
  public function setSeverity($severity)
  {
    $this->severity = $severity;
  }
  /**
   * @return string
   */
  public function getSeverity()
  {
    return $this->severity;
  }
  /**
   * Any summary information provided about this patch.
   *
   * @param string $summary
   */
  public function setSummary($summary)
  {
    $this->summary = $summary;
  }
  /**
   * @return string
   */
  public function getSummary()
  {
    return $this->summary;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ZypperPatch::class, 'Google_Service_CloudAsset_ZypperPatch');
