<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Cloudchannel;

class GoogleCloudChannelV1Media extends \Google\Model
{
  /**
   * Not used.
   */
  public const TYPE_MEDIA_TYPE_UNSPECIFIED = 'MEDIA_TYPE_UNSPECIFIED';
  /**
   * Type of image.
   */
  public const TYPE_MEDIA_TYPE_IMAGE = 'MEDIA_TYPE_IMAGE';
  /**
   * URL of the media.
   *
   * @var string
   */
  public $content;
  /**
   * Title of the media.
   *
   * @var string
   */
  public $title;
  /**
   * Type of the media.
   *
   * @var string
   */
  public $type;

  /**
   * URL of the media.
   *
   * @param string $content
   */
  public function setContent($content)
  {
    $this->content = $content;
  }
  /**
   * @return string
   */
  public function getContent()
  {
    return $this->content;
  }
  /**
   * Title of the media.
   *
   * @param string $title
   */
  public function setTitle($title)
  {
    $this->title = $title;
  }
  /**
   * @return string
   */
  public function getTitle()
  {
    return $this->title;
  }
  /**
   * Type of the media.
   *
   * Accepted values: MEDIA_TYPE_UNSPECIFIED, MEDIA_TYPE_IMAGE
   *
   * @param self::TYPE_* $type
   */
  public function setType($type)
  {
    $this->type = $type;
  }
  /**
   * @return self::TYPE_*
   */
  public function getType()
  {
    return $this->type;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudChannelV1Media::class, 'Google_Service_Cloudchannel_GoogleCloudChannelV1Media');
