<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Contentwarehouse;

class GoogleCloudContentwarehouseV1DeleteDocumentAction extends \Google\Model
{
  /**
   * Boolean field to select between hard vs soft delete options. Set 'true' for
   * 'hard delete' and 'false' for 'soft delete'.
   *
   * @var bool
   */
  public $enableHardDelete;

  /**
   * Boolean field to select between hard vs soft delete options. Set 'true' for
   * 'hard delete' and 'false' for 'soft delete'.
   *
   * @param bool $enableHardDelete
   */
  public function setEnableHardDelete($enableHardDelete)
  {
    $this->enableHardDelete = $enableHardDelete;
  }
  /**
   * @return bool
   */
  public function getEnableHardDelete()
  {
    return $this->enableHardDelete;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudContentwarehouseV1DeleteDocumentAction::class, 'Google_Service_Contentwarehouse_GoogleCloudContentwarehouseV1DeleteDocumentAction');
