<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DataManager;

class IngestPairDataStatus extends \Google\Model
{
  /**
   * The total count of pair ids sent in the upload request for the destination.
   * Includes all pair ids in the request, regardless of whether they were
   * successfully ingested or not.
   *
   * @var string
   */
  public $pairIdCount;
  /**
   * The total count of audience members sent in the upload request for the
   * destination. Includes all audience members in the request, regardless of
   * whether they were successfully ingested or not.
   *
   * @var string
   */
  public $recordCount;

  /**
   * The total count of pair ids sent in the upload request for the destination.
   * Includes all pair ids in the request, regardless of whether they were
   * successfully ingested or not.
   *
   * @param string $pairIdCount
   */
  public function setPairIdCount($pairIdCount)
  {
    $this->pairIdCount = $pairIdCount;
  }
  /**
   * @return string
   */
  public function getPairIdCount()
  {
    return $this->pairIdCount;
  }
  /**
   * The total count of audience members sent in the upload request for the
   * destination. Includes all audience members in the request, regardless of
   * whether they were successfully ingested or not.
   *
   * @param string $recordCount
   */
  public function setRecordCount($recordCount)
  {
    $this->recordCount = $recordCount;
  }
  /**
   * @return string
   */
  public function getRecordCount()
  {
    return $this->recordCount;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(IngestPairDataStatus::class, 'Google_Service_DataManager_IngestPairDataStatus');
