<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dns;

class PolicyNetwork extends \Google\Model
{
  /**
   * @var string
   */
  public $kind;
  /**
   * The fully qualified URL of the VPC network to bind to. This should be
   * formatted like https://www.googleapis.com/compute/v1/projects/{project}/glo
   * bal/networks/{network}
   *
   * @var string
   */
  public $networkUrl;

  /**
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * The fully qualified URL of the VPC network to bind to. This should be
   * formatted like https://www.googleapis.com/compute/v1/projects/{project}/glo
   * bal/networks/{network}
   *
   * @param string $networkUrl
   */
  public function setNetworkUrl($networkUrl)
  {
    $this->networkUrl = $networkUrl;
  }
  /**
   * @return string
   */
  public function getNetworkUrl()
  {
    return $this->networkUrl;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(PolicyNetwork::class, 'Google_Service_Dns_PolicyNetwork');
